/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.layout;

import java.util.Map;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.assets.model.OverlapType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;

public class TileLayout {
    public static final char WALL_CHARACTER = 'X';
    public static final char SPACE_CHARACTER = '.';
    private static final GameMaterial MOCK_MATERIAL = new GameMaterial("brick", 1L, GameMaterialType.OTHER);
    private static final FloorType MOCK_FLOOR_DEFINITION = new FloorType("mock floor definition", -1L, GameMaterialType.OTHER, 0, 0, new OverlapType("mock overlap type"), false, null, null);
    private static final WallType MOCK_WALL_TYPE = new WallType("Mock wall type", "TEST.I18NKEY", 0L, GameMaterialType.OTHER, false);
    private final int id;
    private final LayoutCheck layoutCheck;

    public TileLayout(TileNeighbours neighbours, LayoutCheck layoutCheck) {
        int wallLayoutId = 0;
        for (Map.Entry entry : neighbours.entrySet()) {
            if (entry.getValue() == null || !layoutCheck.doesNeighbourAffectLayout((MapTile)entry.getValue(), (CompassDirection)((Object)entry.getKey()))) continue;
            wallLayoutId |= ((CompassDirection)((Object)entry.getKey())).getBinaryMask();
        }
        this.id = wallLayoutId;
        this.layoutCheck = layoutCheck;
    }

    public TileLayout(int id) {
        this.id = id;
        this.layoutCheck = (tile, direction) -> false;
    }

    public static TileLayout fromString(String diagram, LayoutCheck layoutCheck) {
        diagram = diagram.replaceAll("\n", "");
        TileNeighbours neighbours = new TileNeighbours();
        for (CompassDirection compassDirection : CompassDirection.values()) {
            neighbours.put(compassDirection, new MapTile(0L, compassDirection.getXOffset(), compassDirection.getYOffset(), MOCK_FLOOR_DEFINITION, MOCK_MATERIAL));
            TileLayout.setIfWallInDirection(compassDirection, diagram, neighbours);
        }
        return new TileLayout(neighbours, (tile, direction) -> tile.hasWall());
    }

    private static void setIfWallInDirection(CompassDirection direction, String diagram, TileNeighbours neighbours) {
        if (TileLayout.wallAtIndex(direction.getIndex(), diagram)) {
            ((MapTile)neighbours.get((Object)direction)).addWall(new TileNeighbours(), MOCK_MATERIAL, MOCK_WALL_TYPE);
        }
    }

    private static boolean wallAtIndex(int index, String diagram) {
        return diagram.charAt(index) == 'X';
    }

    public TileLayout reduceToMeaningfulForm() {
        char[] characters = this.toString().replaceAll("\n", "").toCharArray();
        this.emptyCornerIfEitherSiblingIsEmpty(characters, CompassDirection.NORTH_WEST, CompassDirection.NORTH, CompassDirection.WEST);
        this.emptyCornerIfEitherSiblingIsEmpty(characters, CompassDirection.NORTH_EAST, CompassDirection.NORTH, CompassDirection.EAST);
        this.emptyCornerIfEitherSiblingIsEmpty(characters, CompassDirection.SOUTH_WEST, CompassDirection.SOUTH, CompassDirection.WEST);
        this.emptyCornerIfEitherSiblingIsEmpty(characters, CompassDirection.SOUTH_EAST, CompassDirection.SOUTH, CompassDirection.EAST);
        return TileLayout.fromString(String.valueOf(characters), this.layoutCheck);
    }

    private void emptyCornerIfEitherSiblingIsEmpty(char[] characters, CompassDirection corner, CompassDirection sibling1, CompassDirection sibling2) {
        if (characters[sibling1.getIndex()] == '.' || characters[sibling2.getIndex()] == '.') {
            characters[corner.getIndex()] = 46;
        }
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.topRow() + "\n" + this.middleRow() + "\n" + this.bottomRow();
    }

    private StringBuilder addWallCharacterIf(boolean isWall, StringBuilder builder) {
        if (isWall) {
            builder.append('X');
        } else {
            builder.append('.');
        }
        return builder;
    }

    private boolean meaningfulTileInDirection(CompassDirection direction) {
        return (this.id & direction.getBinaryMask()) > 0;
    }

    public String topRow() {
        StringBuilder row = new StringBuilder();
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.NORTH_WEST), row);
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.NORTH), row);
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.NORTH_EAST), row);
        return row.toString();
    }

    public String middleRow() {
        StringBuilder row = new StringBuilder();
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.WEST), row);
        row.append('X');
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.EAST), row);
        return row.toString();
    }

    public String bottomRow() {
        StringBuilder row = new StringBuilder();
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.SOUTH_WEST), row);
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.SOUTH), row);
        this.addWallCharacterIf(this.meaningfulTileInDirection(CompassDirection.SOUTH_EAST), row);
        return row.toString();
    }

    public static interface LayoutCheck {
        public boolean doesNeighbourAffectLayout(MapTile var1, CompassDirection var2);
    }
}

